

#
# Created by Rui Santos
# Complete project details: http://randomnerdtutorials.com
# Modified by: Ingmar Stapel
#

import paho.mqtt.client as mqtt
from flask import Flask, render_template, request
from flask_socketio import SocketIO, emit

app = Flask(__name__)
app.config['SECRET_KEY'] = 'secret!'
socketio = SocketIO(app)

# The callback for when the client receives a CONNACK response from the server.
def on_connect(client, userdata, flags, rc):
    print("Connected with result code "+str(rc))

    # Subscribing in on_connect() means that if we lose the connection and
    # reconnect then subscriptions will be renewed.
	# Sensor 1 a single ESP8266 with two sensor for in-door and out-door
    # in-door
    client.subscribe("/esp8266/sensor1_temperature_1")
    client.subscribe("/esp8266/sensor1_humidity_1")
    # out-door
    client.subscribe("/esp8266/sensor1_temperature_2")
    client.subscribe("/esp8266/sensor1_humidity_2")
    # Sensor 2
    client.subscribe("/esp8266/sensor2_temperature_1")
    client.subscribe("/esp8266/sensor2_humidity_1")
	
# The callback for when a PUBLISH message is received from the ESP8266.
def on_message(client, userdata, message):
    #socketio.emit('my variable')
    print("Received message '" + str(message.payload) + "' on topic '"
        + message.topic + "' with QoS " + str(message.qos))
	# Sensor 1 in-door
    if message.topic == "/esp8266/sensor1_temperature_1":
        print("Sensor 1 temperature update 1")
        socketio.emit('sensor1_dht_temperature1', {'data': message.payload})
    if message.topic == "/esp8266/sensor1_humidity_1":
        print("Sensor 1 humidity update 1")
        socketio.emit('sensor1_dht_humidity1', {'data': message.payload})
    # Sensor 1 out-door
    if message.topic == "/esp8266/sensor1_temperature_2":
        print("Sensor 1 temperature update 2")
        socketio.emit('sensor1_dht_temperature2', {'data': message.payload})
    if message.topic == "/esp8266/sensor1_humidity_2":
        print("Sensor 1 humidity update 2")
        socketio.emit('sensor1_dht_humidity2', {'data': message.payload})	
    # Sensor 2 in-door
    if message.topic == "/esp8266/sensor2_temperature_1":
        print("Sensor 2 temperature update 1")
        socketio.emit('sensor2_dht_temperature1', {'data': message.payload})
    if message.topic == "/esp8266/sensor2_humidity_1":
        print("Sensor 2 humidity update 1")
        socketio.emit('sensor2_dht_humidity1', {'data': message.payload})			
mqttc=mqtt.Client()
mqttc.on_connect = on_connect
mqttc.on_message = on_message
# Wenn der Flask Web-Server auf dem gleichen Raspberry Pi laeuft kann hier als
# connection String localhost statt einer IP-Adresse verwendet werden.
mqttc.connect("localhost",1883,60)
mqttc.loop_start()

# Create a dictionary called pins to store the pin number, name, and pin state:
pins = {
   4 : {'name' : 'GPIO 4', 'board' : 'esp8266', 'topic' : 'esp8266/4', 'state' : 'False'},
   5 : {'name' : 'GPIO 5', 'board' : 'esp8266', 'topic' : 'esp8266/5', 'state' : 'False'}
   }

# Put the pin dictionary into the template data dictionary:
templateData = {
   'pins' : pins
   }

@app.route("/")
def main():
   # Pass the template data into the template main.html and return it to the user
   return render_template('main.html', async_mode=socketio.async_mode, **templateData)

# The function below is executed when someone requests a URL with the pin number and action in it:
@app.route("/<board>/<changePin>/<action>")
def action(board, changePin, action):
   # Convert the pin from the URL into an integer:
   changePin = int(changePin)
   # Get the device name for the pin being changed:
   devicePin = pins[changePin]['name']
   # If the action part of the URL is "1" execute the code indented below:
   if action == "1" and board == 'esp8266':
      mqttc.publish(pins[changePin]['topic'],"1")
      pins[changePin]['state'] = 'True'
   if action == "0" and board == 'esp8266':
      mqttc.publish(pins[changePin]['topic'],"0")
      pins[changePin]['state'] = 'False'
   # Along with the pin dictionary, put the message into the template data dictionary:
   templateData = {
      'pins' : pins
   }
   return render_template('main.html', **templateData)

@socketio.on('my event')
def handle_my_custom_event(json):
    print('received json data here: ' + str(json))

if __name__ == "__main__":
   socketio.run(app, host='0.0.0.0', port=8181, debug=True)

